

global x
global fr
global Fs
global Br
global Dn
global fd
global fmax
global l
% global ratio

Fs = 12000;    % Sampling Frequency (Hz)
% Dr = 1;    % [Drive_end bearing ;  Fan_end bearing] = [1; 0]
Br = 1;    % [B1&B3 bearing ;  B2 bearing] = [1; 0]
Dn = [1 2 3 4];    % BPFI = 1, BPFO = 2, FTF = 3, BSF = 4;

%%%% Damage on the INNER RING
% filelist = [107];   

%%%% Damage on the OUTER RING
% filelist = [132];   %0.007 fault dia


%%%% Damage on the Ball
filelist = [187];  %0.007 fault dia

% %%%% Politecnico test file
% load C3A_100_000_1;
% x(:,1) = C3A_100_000_1(:,3);

% NFFT=2^17;
% WINDOW=NFFT;
% NOVERLAP=round(2/3*NFFT);
% [P,F] = pwelch(x,WINDOW,NOVERLAP,NFFT,Fs);
% semilogy(F,P);

%To find the Real-spin frequency

% N = length(x); % Length of the signal
% freq = (0:1:N-1)*(Fs/N); % Frequency vector
% fft_signal = abs(fft(x)); % Magnitude of FFT
% FF = freq(1:floor(N/2));
% SS = fft_signal(1:floor(N/2));

%%
%%%%target fr
% target_fr =  92.5; 
% tolerance = 5;   

% [ijk optimum] = min(abs(F-target_fr));
% optimum_indexmax = optimum+20;  
% optimum_indexmin = optimum-20; 
% [ijk optimum] = max(P(optimum_indexmin:optimum_indexmax));
% optimum=optimum+optimum_indexmin-1;
% fr = F(optimum);  

% disp(['Real shaft speed (fr) with tolerance: ', num2str(fr), ' Hz']);

AllDamages_Autogram = [];
AllDamages_FastKurtogram = [];
AllDamages_FastAutogram = [];
AllDamages_SAM = [];
AllDamages_SC = [];
Names_Files = {};

for i=1:length(filelist)
    file = filelist(i);


% str = ['folder=''C:\Users\Dinesh\Desktop\New_folder\Thesis\Polito\Rolling_Bearings\FK-Auto-FastAuto\current_results\Inner_Race\all_data_files\'''];
% str = ['folder=''C:\Users\Dinesh\Desktop\New_folder\Thesis\Polito\Rolling_Bearings\FK-Auto-FastAuto\current_results\Outer_Race\all_data_files\'''];
str = ['folder=''C:\Users\Dinesh\Desktop\New_folder\Thesis\Polito\Rolling_Bearings\FK-Auto-FastAuto\current_results\Ball\all_data_files\'''];
% str = ['folder=''C:\Users\Dinesh\Desktop\New_folder\Thesis\Polito\Rolling_Bearings\Thesis report\VariableSpeedAndLoad\VariableSpeedAndLoad\'''];


eval(str)

str = ['load '  folder num2str(file);''];
eval(str);

str = ['xx = X' num2str(file) '_FE_time;'];
eval(str);
x = xx;
str = ['fr = X' num2str(file) 'RPM/60;']; % Shaft speed in Hz
eval(str);

% Ratios of damage frequencies to shaft speed
ratio = [5.415 3.585 0.3983 2.357; 4.947 3.053 0.3816 1.994];
% ratio = [6.111 3.889 0.389 4.2780; 9.185 6.815 0.426 6.6020];
if Br == 1
    j = 1;
else
    j = 2;
end

fd = fr * ratio(j, Dn);

% Loop through each defect type in Dn
l = [3 4];
for  s = 1:length(l) 
    damage_type = l(s);   % Setting current damage_type

    if damage_type == 1  %Inner race
        fmax = (2 * fd(l(s)) + fr) * 1.1;
        disp(['Inner race: fmax = ', num2str(fmax)]);
        
    elseif damage_type == 2  %Outer race
        fmax = (3 * fd(l(s))) * 1.1;
        disp(['Outer race: fmax = ', num2str(fmax)]);
        
    elseif damage_type == 3  %Cage
        fmax = (25 * fd(l(s))) * 1.1;
        disp(['Cage: fmax = ', num2str(fmax)]);
        
    elseif damage_type == 4  %Ball
        fmax = (5 * fd(l(s))) * 1.1;
        disp(['Ball: fmax = ', num2str(fmax)]);
        
    end
end 
Demo_Autogram  
disp(damage_Autogram)
disp(Error_Autogram)

Demo_FastKurtogram
disp(damage_FastKurtogram)
disp(Error_FastKurtogram)

Demo_FastAutogram
disp(damage_FastAutogram)
disp(Error_FastAutogram)

Demo_SAM
disp(damage_SAM)
disp(Error_SAM)

Demo_SC
disp(damage_SC)
disp(Error_SC)

AllDamages_Autogram = [AllDamages_Autogram; damage_Autogram];
AllDamages_FastKurtogram = [AllDamages_FastKurtogram; damage_FastKurtogram];
AllDamages_FastAutogram = [AllDamages_FastAutogram; damage_FastAutogram];
AllDamages_SAM = [AllDamages_SAM; damage_SAM];
AllDamages_SC = [AllDamages_SC; damage_SC];

Names_Files = [Names_Files; {num2str(file)}];
end

%% 

% Display AllDamages
disp('Autogram Damages:');
disp(AllDamages_Autogram);

disp('FastKurtogram Damages:');
disp(AllDamages_FastKurtogram);

disp('FastAutogram Damages:');
disp(AllDamages_FastAutogram);

disp('SAM Damages:');
disp(AllDamages_SAM);

disp('SC Damages:');
disp(AllDamages_SC);

% Plotting damages for each data file
figure;
numFiles = length(filelist);
for k = 1:numFiles
    subplot(numFiles, 1, k);
    bar_data = [AllDamages_Autogram(k), AllDamages_FastKurtogram(k), AllDamages_FastAutogram(k), AllDamages_SAM(k), AllDamages_SC(k)];
    bar(bar_data, 'FaceColor', [1 0 0], 'EdgeColor', 'none');
    set(gca, 'XTickLabel', {'Autogram', 'FastKurtogram', 'FastAutogram', 'SAM', 'SC'});
    xlabel('Techniques');
    ylabel('Damage Value');
    % title(['Damages for File ', num2str(filelist(k))]);
    title('Damages for File ');
    grid on;
end

% Plotting damages for each data file
% figure;
%     bar_data = [damage_Autogram; damage_FastKurtogram; damage_FastAutogram; damage_SC];
%     bar(bar_data, 'FaceColor', [1 0 0], 'EdgeColor', 'none');
%     set(gca, 'XTickLabel', {'Autogram', 'FastKurtogram', 'FastAutogram', 'SC'});
%     xlabel('Techniques');
%     ylabel('Damage Value');
%     title('Damages for File ');
%     grid on;

